<?php
namespace Piggly\Tests\Pix\Api\Entities;

use PHPUnit\Framework\TestCase;
use Piggly\Pix\Api\Payloads\Entities\Amount;
use Piggly\Pix\Api\Payloads\Entities\DueAmountModality;

/**
 * @coversDefaultClass \Piggly\Pix\Api\Payloads\Entities\Amount
 */
class AmountTest extends TestCase
{
	/**
	 * Assert if $payload is equals to $obj exported.
	 * 
	 * Anytime it runs will create 100 random unique
	 * payloads. It must assert all anytime.
	 *
	 * @covers ::import
	 * @covers ::export
	 * @covers DueAmountModality::export
	 * @dataProvider dataAmounts
	 * @test Expecting positive assertion.
	 * @param array $payload
	 * @param Amount $obj
	 * @return void
	 */
	public function isMatching ( array $payload, Amount $obj )
	{ $this->assertEquals($payload, $obj->export()); }

	/**
	 * Assert if $actual is equals to $expected.
	 * 
	 * Anytime it runs will create 100 random unique
	 * payloads. It must assert all anytime.
	 *
	 * @covers ::setOriginal
	 * @covers ::setFinal
	 * @covers ::addModality
	 * @covers ::getOriginal
	 * @covers ::getFinal
	 * @covers ::getModality
	 * @dataProvider dataFormats
	 * @test Expecting positive assertion.
	 * @param mixed $expected
	 * @param mixed $actual
	 * @return void
	 */
	public function isMatchingFormat ( $expected, $actual )
	{ $this->assertEquals($expected, $actual); }

	/**
	 * A bunch of pixs to import to Amount payload.
	 * Provider to isMatching() method.
	 * Generated by fakerphp.
	 * @return array
	 */
	public function dataAmounts () : array
	{
		$arr = [];
		$faker = \Faker\Factory::create('pt_BR');

		for ( $i = 0; $i < 100; $i++ )
		{
			$payload = [
				'original' => \number_format($faker->randomFloat(2, 1, 999), 2, '.', '')
			];

			if ( $faker->boolean() )
			{ $payload['final'] = \number_format($faker->randomFloat(2, 1, 999), 2, '.', ''); }

			if ( $faker->boolean() )
			{ $payload[DueAmountModality::MODALITY_BANKFINE] = $this->_getModality($faker, DueAmountModality::MODALITY_BANKFINE)->export(); }

			if ( $faker->boolean() )
			{ $payload[DueAmountModality::MODALITY_DISCOUNT] = $this->_getModality($faker, DueAmountModality::MODALITY_DISCOUNT)->export(); }

			if ( $faker->boolean() )
			{ $payload[DueAmountModality::MODALITY_FEE] = $this->_getModality($faker, DueAmountModality::MODALITY_FEE)->export(); }

			if ( $faker->boolean() )
			{ $payload[DueAmountModality::MODALITY_REDUCTION] = $this->_getModality($faker, DueAmountModality::MODALITY_REDUCTION)->export(); }

			$arr[] = [ $payload, (new Amount())->import($payload) ];
		}

		return $arr;
	}

	/**
	 * A bunch of pixs to validate data.
	 * Provider to isMatchingFormat() method.
	 * Generated by fakerphp.
	 * @return array
	 */
	public function dataFormats () : array
	{
		$arr = [];
		$faker = \Faker\Factory::create('pt_BR');

		for ( $i = 0; $i < 100; $i++ )
		{
			$original = $faker->randomFloat(2, 1, 999);
			$final = $faker->randomFloat(2, 1, 999);
			$modality = $this->_getModality($faker, DueAmountModality::MODALITY_BANKFINE);

			$amount = new Amount();

			$amount
				->setOriginal(\number_format($original, 2, '.', ''))
				->setFinal(\number_format($final, 2, '.', ''))
				->addModality($modality);

			$arr[] = [ $original, $amount->getOriginal() ];
			$arr[] = [ $final, $amount->getFinal() ];
			$arr[] = [ $modality, $amount->getModality($modality->getModality()) ];
		}

		return $arr;
	}

	/**
	 * Get a modality.
	 *
	 * @param \Faker\Generator $faker
	 * @param string $type
	 * @return DueAmountModality
	 */
	private function _getModality ( $faker, $type ) : DueAmountModality 
	{
		switch ( $type )
		{
			case DueAmountModality::MODALITY_BANKFINE:
				$list = DueAmountModality::BANKFINE_MODALITIES;
				break;
			case DueAmountModality::MODALITY_DISCOUNT:
				$list = DueAmountModality::DISCOUNT_MODALITIES;
				break;
			case DueAmountModality::MODALITY_FEE:
				$list = DueAmountModality::FEE_MODALITIES;
				break;
			case DueAmountModality::MODALITY_REDUCTION:
				$list = DueAmountModality::REDUCTION_MODALITIES;
				break;
		}

		return (new DueAmountModality($type))
					->setId($faker->randomElement($list))
					->setAmount(\number_format($faker->randomFloat(2, 1, 999), 2, '.', ''));
	}
}