<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="content d-flex flex-column flex-column-fluid" id="kt_content" >

			<div class="row" id="anime" style="display: none">
				<div class="col s8 offset-s2">
					<lottie-player src="/anime/success.json" background="transparent" speed="0.8" style="width: 100%; height: 300px;" autoplay >
					</lottie-player>
				</div>
			</div>

			<div class="col-lg-12" id="content">
				<!--begin::Portlet-->

				<h3 class="card-title">Venda código: <strong><?php echo e($venda->id); ?></strong></h3>

				<div class="row">
					<div class="col-xl-12">

						<div class="kt-section kt-section--first">
							<div class="kt-section__body">

								<div class="row">
									

									<div class="col-12">
										<h4>Estado: 
											<?php if($venda->estado == 'DISPONIVEL'): ?>
											<span class="label label-xl label-inline label-light-primary">Disponível</span>

											<?php elseif($venda->estado == 'APROVADO'): ?>
											<span class="label label-xl label-inline label-light-success">Aprovado</span>
											<?php elseif($venda->estado == 'CANCELADO'): ?>
											<span class="label label-xl label-inline label-light-danger">Cancelado</span>
											<?php else: ?>
											<span class="label label-xl label-inline label-light-warning">Rejeitado</span>
											<?php endif; ?>
										</h4>

										<h4>Chave NFCe: <strong class="text-info"><?php echo e($venda->chave != "" ? $venda->chave : '--'); ?></strong></h4>
										
										<?php if($adm): ?>
										<a href="/nfce/estadoFiscal/<?php echo e($venda->id); ?>" class="btn btn-danger">
											<i class="la la-warning"></i>
											Alterar estado fiscal da venda
										</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<hr>
				<div class="row">
					<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">
						<h3>Itens da Venda</h3>
						<table class="datatable-table" style="max-width: 100%; overflow: scroll;" id="prod">
							<thead class="datatable-head">
								<tr class="datatable-row" style="left: 0px;">
									<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">ID</span></th>
									<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 450px;">Produto</span></th>
									<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Quantidade</span></th>
									<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Valor</span></th>
									<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Subtotal</span></th>
								</tr>
							</thead>

							<tbody class="datatable-body">
								<?php $somaItens = 0; ?>
								<?php $__currentLoopData = $venda->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr class="datatable-row" style="left: 0px;">

									<td class="datatable-cell"><span class="codigo" style="width: 120px;"><?php echo e($i->produto->id); ?></span></td>
									<td class="datatable-cell">
										<span class="codigo" style="width: 450px;"><?php echo e($i->produto->nome); ?> 
											<?php echo e($i->produto->grade ? " (" . $i->produto->str_grade . ")" : ""); ?>

										</span>
									</td>

									<td class="datatable-cell"><span class="codigo" style="width: 120px;"><?php echo e(number_format($i->quantidade, $casasDecimaisQtd)); ?></span></td>
									<td class="datatable-cell"><span class="codigo" style="width: 120px;"><?php echo e(number_format($i->valor, $casasDecimais, ',', '.')); ?></span></td>

									<td class="datatable-cell"><span class="codigo" style="width: 120px;"><?php echo e(number_format($i->valor*$i->quantidade, $casasDecimais, ',', '.')); ?></span></td>


								</tr>
								<?php $somaItens+=  $i->valor * $i->quantidade?>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
					<h4>Soma: <strong class="text-info">R$ <?php echo e(number_format($somaItens, $casasDecimais, ',', '.')); ?></strong></h4>
				</div>

				<hr>

				<div class="row">
					<?php if($venda->NFcNumero && $venda->estado == 'APROVADO'): ?>

					<a target="_blank" href="/nfce/imprimir/<?php echo e($venda->id); ?>" class="btn btn-lg btn-light-success">
						<i class="la la-print"></i>
						Imprimir fiscal
					</a>

					<?php endif; ?>

					<a style="margin-left: 5px;" target="_blank" href="/nfce/imprimirNaoFiscal/<?php echo e($venda->id); ?>" class="btn btn-lg btn-light-info">
						<i class="la la-print"></i>
						Imprimir não fiscal
					</a>

					<?php if($venda->isComprovanteAssessor()): ?>
					<a style="margin-left: 5px;" target="_blank" href="/nfce/imprimirComprovanteAssessor/<?php echo e($venda->id); ?>" class="btn btn-lg btn-light-primary">
						<i class="la la-print"></i>
						Imprimir comprovante assessor
					</a>
					<?php endif; ?>
				</div>

			</div>
		</div>
	</div>
</div>




<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/frontBox/detalhes.blade.php ENDPATH**/ ?>