<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CategoriaProdutoDelivery extends Model
{
    protected $fillable = [
        'nome', 'descricao', 'path', 'empresa_id', 'tipo_pizza'
    ];

    public function produtos(){
        return $this->hasMany(ProdutoDelivery::class, 'categoria_id', 'id')->with('produto')
        ->with('pizza');
    }

    public function adicionais(){
        return $this->hasMany('App\Models\ListaComplementoDelivery', 'categoria_id', 'id');
    }
}
