<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\VendaCaixa;
use App\Helpers\StockMove;
use App\Models\ItemVendaCaixa;
use App\Models\CreditoVenda;
use App\Models\ConfigNota;
use App\Models\PedidoDelivery;
use App\Models\Produto;
use App\Models\ProdutoPizza;
use App\Models\Pedido;
use App\Models\AberturaCaixa;
use App\Models\ComissaoVenda;
use App\Models\ContaReceber;
use App\Models\Acessor;
use App\Models\FaturaFrenteCaixa;
use App\Models\ComissaoAssessor;
use App\Models\Usuario;
use App\Models\Funcionario;
use App\Models\Agendamento;
use App\Models\CategoriaConta;
use App\Models\NaturezaOperacao;
use App\Models\ConfigCaixa;
use App\Models\TrocaVenda;
use App\Models\TrocaVendaCaixa;
use App\Models\VendaCaixaPreVenda;
use App\Models\ItemVendaCaixaPreVenda;
use Illuminate\Support\Facades\DB;

class VendaCaixaController extends Controller
{
  protected $empresa_id = null;
  public function __construct(){
    $this->middleware(function ($request, $next) {
      $this->empresa_id = $request->empresa_id;
      $value = session('user_logged');
      if(!$value){
        return redirect("/login");
      }
      return $next($request);
    });
  }

  private function criarLog($objeto, $tipo = 'criar'){
    if(isset(session('user_logged')['log_id'])){
      $record = [
        'tipo' => $tipo,
        'usuario_log_id' => session('user_logged')['log_id'],
        'tabela' => 'venda_caixas',
        'registro_id' => $objeto->id,
        'empresa_id' => $this->empresa_id
      ];
      __saveLog($record);
    }
  }
  
  public function save(Request $request){
    try{
      $result = DB::transaction(function () use ($request) {
        $venda = $request->venda;
        $agendamento_id = $venda['agendamento_id'];
        $fromPrevenda = isset($venda['isPrevenda']) ? 
        ($venda['isPrevenda'] == 'true' ? true : false) : false;

        $config = ConfigNota::
        where('empresa_id', $this->empresa_id)
        ->first();

        $pag_multi = isset($venda['pag_multi']) ? $venda['pag_multi'] : [];
    // return response()->json($pag_multi, 401);

        $totalVenda = str_replace(",", ".", $venda['valor_total']) + str_replace(",", ".", $venda['acrescimo']) - str_replace(",", ".", $venda['desconto']);

        $func = null;
        $usr = null;

        $idUsr = get_id_user();
        if(isset($venda['funcionario_id'])){
          $func = Funcionario::find($venda['funcionario_id']);
          $idUsr = $func == null ? get_id_user() : $func->usuario->id;

        }

        if(isset($venda['vendedor_id']) && $venda['vendedor_id'] != ''){
          $usr = Usuario::find($venda['vendedor_id']);  
          $idUsr = $usr == null ? get_id_user() : $usr->id;
        }

        $assessor = null;
        if(isset($venda['assessor_id']) && $venda['assessor_id']){
          $assessor = Acessor::find($venda['assessor_id']);
        }

        if($venda['id'] == 0){

          $result = VendaCaixa::create([
            'cliente_id' => $venda['cliente'],
            'usuario_id' => $idUsr,
            'natureza_id' => $config->nat_op_padrao,
            'valor_total' => $totalVenda,
            'acrescimo' => str_replace(",", ".", $venda['acrescimo']),
            'troco' => str_replace(",", ".", $venda['troco']),
            'dinheiro_recebido' => str_replace(",", ".", $venda['dinheiro_recebido']),
            'forma_pagamento' => $venda['acao'] == 'credito' ? 'credito' : " ",
            'tipo_pagamento' => sizeof($pag_multi) > 0 ? '99' : $venda['tipo_pagamento'],
            'estado' => 'DISPONIVEL',
            'NFcNumero' => 0,
            'chave' => '',
            'path_xml' => '',
            'nome' => $venda['nome'] ?? '',
            'rascunho' => $venda['rascunho'],
            'credito_troca' => $venda['credito_troca'] ? $venda['desconto'] : 0,
            'consignado' => $venda['consignado'],
            'cpf' => $venda['cpf'] ?? '',
            'observacao' => $venda['observacao'] ?? '',
            'desconto' => $venda['desconto'],
            'pedido_delivery_id' => isset($venda['delivery_id']) ? $venda['delivery_id'] : 0,
            'tipo_pagamento_1' => $venda['tipo_pagamento_1'] ?? '', 
            'valor_pagamento_1' => $venda['valor_pagamento_1'] ? __replace($venda['valor_pagamento_1']) :  0,
            'tipo_pagamento_2' => $venda['tipo_pagamento_2'] ?? '',
            'valor_pagamento_2' => $venda['valor_pagamento_2'] ? __replace($venda['valor_pagamento_2']) : 0,
            'tipo_pagamento_3' => $venda['tipo_pagamento_3'] ?? '',
            'valor_pagamento_3' => $venda['valor_pagamento_3'] ? __replace($venda['valor_pagamento_3']) : 0,
            'empresa_id' => $this->empresa_id,
            'bandeira_cartao' => $venda['bandeira_cartao'],
            'cAut_cartao' => $venda['cAut_cartao'] ?? '',
            'cnpj_cartao' => $venda['cnpj_cartao'] ?? '',
            'descricao_pag_outros' => $venda['descricao_pag_outros'] ?? '',
          ]);

          $this->criarLog($result);

        }else{
          if($fromPrevenda){
            $result = VendaCaixaPreVenda::find($venda['id']);
          }else{
            $result = VendaCaixa::find($venda['id']);
          }

          $result->cliente_id = $venda['cliente'];
          $result->usuario_id = get_id_user();
          $result->natureza_id = $config->nat_op_padrao;
          $result->valor_total = $totalVenda;
          $result->acrescimo = str_replace(",", ".", $venda['acrescimo']);
          $result->troco = str_replace(",", ".", $venda['troco']);
          $result->dinheiro_recebido = str_replace(",", ".", $venda['dinheiro_recebido']);
          $result->forma_pagamento = $venda['acao'] == 'credito' ? 'credito' : " ";
          $result->tipo_pagamento = sizeof($pag_multi) > 0 ? '99' : $venda['tipo_pagamento'];
          $result->estado = 'DISPONIVEL';
          $result->NFcNumero = 0;
          $result->chave = '';
          $result->path_xml = '';
          $result->nome = $venda['nome'] ?? '';
          $result->rascunho = $venda['rascunho'];
          if(isset($result->consignado)){
            $result->consignado = $venda['consignado'];
          }
          $result->cpf = $venda['cpf'] ?? '';
          $result->observacao = $venda['observacao'] ?? '';
          $result->desconto = $venda['desconto'];
          $result->pedido_delivery_id = isset($venda['delivery_id']) ? $venda['delivery_id'] : 0;
          $result->bandeira_cartao = $venda['bandeira_cartao'];
          $result->cAut_cartao = $venda['cAut_cartao'] ?? '';
          $result->cnpj_cartao = $venda['cnpj_cartao'] ?? '';
          $result->descricao_pag_outros = $venda['descricao_pag_outros'] ?? '';
          $result->prevenda_nivel = 0;
          $this->criarLog($result, 'atualizar');

      // $result->update();
          if($fromPrevenda){
            $prevenda_result = $result;
            unset($result->id);
        // unset($result->created_at);
        // unset($result->updated_at);

            $result = VendaCaixa::create(json_decode($result, true));

            $prevenda_result->update();
          }else{
            $result->update();
          }

          ContaReceber::where('venda_caixa_id', $venda['id'])->delete();
          FaturaFrenteCaixa::where('venda_caixa_id', $venda['id'])->delete();
          ItemVendaCaixa::where('venda_caixa_id', $venda['id'])->delete();
          ComissaoVenda::where('venda_id', $venda['id'])->where('tabela', 'venda_caixas')->delete();
        }

        if($venda['credito_troca']){
      //recalcular valor credito
          $this->recalcularCredito($venda['desconto'], $venda['cliente']);
        }

        if($venda['tipo_pagamento'] == '06' && sizeof($pag_multi) == 0){

          $dataVenc = date('Y-m-d', strtotime("+30 days",
            strtotime(date('Y-m-d'))));
          $categoria = $this->categoriaCrediario();
          $resultConta = ContaReceber::create([
            'venda_caixa_id' => $result->id,
            'venda_id' => NULL,
            'data_vencimento' => $dataVenc,
            'data_recebimento' => $dataVenc,
            'valor_integral' => $totalVenda,
            'valor_recebido' => 0,
            'status' => false,
            'referencia' => "Venda PDV " . $result->id,
            'categoria_id' => $categoria,
            'empresa_id' => $this->empresa_id,
            'cliente_id' => $venda['cliente']
          ]);
        }
        $contCredito = 1;

        if(sizeof($pag_multi) > 0){
          foreach($pag_multi as $p){
            FaturaFrenteCaixa::create([
              'valor' => __replace($p['valor']),
              'forma_pagamento' => $p['tipo'],
              'venda_caixa_id' => $result->id    
            ]);

            if($p['tipo'] == '06'){
          // return response()->json($p['tipo'], 401);
              $this->salvaCredito($result->id, __replace($p['valor']), 
                $venda['cliente'], $p['obs'], $p['vencimento']);
            }
          }
        }

        if($venda['codigo_comanda'] > 0){
          $pedido = Pedido::
          where('comanda', $venda['codigo_comanda'])
          ->where('status', 0)
          ->where('desativado', 0)
          ->first();

          $pedido->status = 1;
          $pedido->desativado = 1;
          $pedido->save();
        }

        $itens = $venda['itens'];
        $stockMove = new StockMove();

        if($fromPrevenda){
      // retorna os itens para o estoque e depois deleta os registros
          $this->adicionaAoEstoque(ItemVendaCaixaPreVenda::where('venda_caixa_prevenda_id', $venda['id'])->get(), $config);
          ItemVendaCaixaPreVenda::where('venda_caixa_prevenda_id', $venda['id'])->delete();
        }
        if(!$fromPrevenda && $venda['id'] != 0){
          $this->adicionaAoEstoque($result->itens, $config);
          ItemVendaCaixa::where('venda_caixa_id', $venda['id'])->delete();
        }

        $natureza = NaturezaOperacao::find($config->nat_op_padrao);

        $valorComissaoAssesor = 0;
        foreach ($itens as $i) {
          $produto = Produto::find($i['id']);
          $cfop = 0;

          if($natureza->sobrescreve_cfop){
            $cfop = $natureza->CFOP_saida_estadual;
          }else{
            $cfop = $produto->CFOP_saida_estadual;
          }

      //calculo comissao assessor
          $prod = Produto
          ::where('id', $i['id'])
          ->first();

          $vlc = 0;
          if($prod->custo_assessor > 0 && $assessor != null){

            $qtd = (float) str_replace(",", ".", $i['quantidade']);
            $valor = (float) str_replace(",", ".", $i['valor']);
            if($assessor->tipo_comissao == 'custo'){
              $vlc = ($valor-$prod->custo_assessor) * $qtd;
            }else{
              $vlc = ($valor*$qtd)*($prod->custo_assessor/100);
            }
            if($vlc > 0){
              $valorComissaoAssesor += $vlc;
            }
          }

          ItemVendaCaixa::create([
            'venda_caixa_id' => $result->id,
            'produto_id' => (int) $i['id'],
            'quantidade' => (float) str_replace(",", ".", $i['quantidade']),
            'valor' => (float) str_replace(",", ".", $i['valor']),
            'item_pedido_id' => isset($i['itemPedido']) ? $i['itemPedido'] : NULL,
            'observacao' => $i['obs'] ?? '',
            'cfop' => $cfop,
            'valor_custo' => $produto->valor_compra,
            'valor_comissao_assessor' => $vlc
          ]);


          if($venda['consignado'] == 0 && $venda['rascunho'] == 0){
            if($config->natureza->nao_movimenta_estoque == false){
              if(!isset($venda['delivery_id']) || $venda['delivery_id'] == 0){
     // nao delivery

                if(isset($venda['pizza']) && $i['pizza'] == 1){
                  $sabores = explode(" | ", $i['nome']);
                  $totalSabores = count($sabores);
                  foreach($sabores as $sb){

                    $produto = Produto::
                    where('nome', $sb)
                    ->first();

                    $produtoPizza = ProdutoPizza::
                    where('produto_id', $i['id'])
                    ->where('valor', $i['valor'])
                    ->first();

                    if(!empty($produto->receita)){
                      $receita = $produto->receita;
                      foreach($receita->itens as $rec){

                        $stockMove->downStock(
                          $rec->produto_id, 
                          (float) str_replace(",", ".", $i['quantidade']) 
                      * 
                          ((($rec->quantidade/$totalSabores)/$receita->pedacos)*$produtoPizza->tamanho->pedacos)/$receita->rendimento
                        );
                      }
                    }


                  }

                }else if(!empty($prod->receita)){

                  $receita = $prod->receita; 

                  foreach($receita->itens as $rec){

                    if(!empty($rec->produto->receita)){ 

                      $receita2 = $rec->produto->receita; 

                      foreach($receita2->itens as $rec2){
                        $stockMove->downStock(
                          $rec2->produto_id, 
                          (float) str_replace(",", ".", $i['quantidade']) * 
                          ($rec2->quantidade/$receita2->rendimento)
                        );
                      }
                    }else{

                      $stockMove->downStock(
                        $rec->produto_id, 
                        (float) str_replace(",", ".", $i['quantidade']) * 
                        ($rec->quantidade/$receita->rendimento)
                      );
                    }
                  }
                  $stockMove->downStock(
                    (int) $i['id'], 
                    (float) str_replace(",", ".", $i['quantidade'])
                  );

                }else{
                  $stockMove->downStock(
                    (int) $i['id'], 
                    (float) str_replace(",", ".", $i['quantidade'])
                  );
                }
              }
            }
          }

        }

        if($valorComissaoAssesor > 0){
          ComissaoAssessor::create([
            'venda_caixa_id' => $result->id,
            'status' => 0,
            'valor' => $valorComissaoAssesor,
            'assessor_id' => $assessor->id
          ]);
        }
        //DELIVERY
        if(isset($venda['delivery_id']) && $venda['delivery_id'] > 0){
          $pedidoDelivery = PedidoDelivery
          ::where('id', $venda['delivery_id'])
          ->first();

          foreach($pedidoDelivery->itens as $i){

            if(count($i->sabores) > 0){

              $totalSabores = count($i->sabores);
              foreach($i->sabores as $sb){
                if(!empty($sb->produto->produto->receita)){
                  $receita = $sb->produto->produto->receita;
                  foreach($receita->itens as $rec){

                    $stockMove->downStock(
                      $rec->produto_id, 
                      (float) str_replace(",", ".", $i['quantidade']) 
                      * 
                      ((($rec->quantidade/$totalSabores)/$receita->pedacos)*$i->tamanho->pedacos)/$receita->rendimento
                    );
                  }
                }
              }
            }else{

              if(!empty($i->produto->produto->receita)){
                $receita = $i->produto->produto->receita; 
                foreach($receita->itens as $rec){

                  if(!empty($rec->produto->receita)){ 

                    $receita2 = $rec->produto->receita; 

                    foreach($receita2->itens as $rec2){
                      $stockMove->downStock(
                        $rec2->produto_id, 
                        (float) str_replace(",", ".", $i['quantidade']) * 
                        ($rec2->quantidade/$receita2->rendimento)
                      );
                    }
                  }else{


                    $stockMove->downStock(
                      $rec->produto_id, 
                      (float) str_replace(",", ".", $i['quantidade']) * 
                      ($rec->quantidade/$receita->rendimento)
                    );
                  }
                }
              }else{

                $stockMove->downStock(
                  $i->produto->produto->id, 
                  (float) str_replace(",", ".", $i['quantidade'])
                );
              }
            }

          }
        }

        $vTemp = VendaCaixa::find($result->id);


        $usuario = Usuario::find($idUsr);

        if($usuario->caixa_livre == 0 && isset($usuario->funcionario)){
          $percentual_comissao = $usuario->funcionario->percentual_comissao;
          $valorComissao = $this->calcularComissaoVenda($vTemp, $percentual_comissao);
          ComissaoVenda::create(
            [
              'funcionario_id' => $usuario->funcionario->id,
              'venda_id' => $result->id,
              'tabela' => 'venda_caixas',
              'valor' => $valorComissao,
              'status' => 0,
              'empresa_id' => $this->empresa_id
            ]
          );
        }else{
          $func = Funcionario::find($venda['funcionario_id']);
          if($func == null && $usr != null){
            $func = $usr->funcionario;
          }
          if($func != null){
            if($func->percentual_comissao > 0){
              $percentual_comissao = $func->percentual_comissao;
              $valorComissao = $this->calcularComissaoVenda($vTemp, $percentual_comissao);
              ComissaoVenda::create(
                [
                  'funcionario_id' => $func->id,
                  'venda_id' => $result->id,
                  'tabela' => 'venda_caixas',
                  'valor' => $valorComissao,
                  'status' => 0,
                  'empresa_id' => $this->empresa_id
                ]
              );
            }
          }
        }

        if($agendamento_id > 0){

          $agendamento = Agendamento::find($agendamento_id);
          $valorComissao = $this->calculaComissao($agendamento);
          $agendamento->valor_comissao = $valorComissao;
          $agendamento->status = 1;
          $agendamento->save();
        }

        $result->comissao_acessor = $valorComissaoAssesor > 0 ? true : false;

        return $result;
      });
echo json_encode($result);

}catch(\Exception $e){
  __saveError($e, $this->empresa_id);
  return response()->json($e->getMessage(), 400);
}
}

public function prevendaAll(){
    //...
  $pv = VendaCaixaPreVenda::where('empresa_id', $this->empresa_id)
  ->where('prevenda_nivel', 2)
  ->orderBy('updated_at', 'desc')
  ->with('cliente')
  ->get();

  foreach($pv as $p){
    $p->cliente = $p->cliente;
    $p->vendedor = $p->vendedor();
    $p->data = \Carbon\Carbon::parse($p->updated_at)->format('d/m/Y - H:i:s');
  }

  return json_encode($pv);
}

public function prevendaRetorno(Request $request){
  $result = VendaCaixaPreVenda::where('empresa_id', $this->empresa_id)->find($request->id);
  $config = ConfigNota::where('empresa_id', $this->empresa_id)->first();

  if($result->prevenda_nivel == 2){
    $result->update(['prevenda_nivel' => 1]);
    $this->adicionaAoEstoque($result->itens, $config);

    return response()->json(['message' => 'ok'], 200);
  }
  return response()->json(['message' => ''], 500);
}

public function savePreVenda(Request $request){
  $venda = $request->venda;

  $config = ConfigNota::
  where('empresa_id', $this->empresa_id)
  ->first();

    // Verifica se precisa de senha para alterar preço dos itens
  if($config->senha_alterar_preco != ''){
      // verifica se o valor de algum item foi alterado

    $itens = $venda['itens'];
    $ids = [];
    foreach($itens as $i){
      array_push($ids, $i['id']);
    }

    $produtos = Produto::whereIn('id', $ids)->get(['id', 'valor_venda', 'nome']);

    $teve_alteracao = 0;

    foreach($itens as $i){

      foreach ($produtos as $p) {
        if ($i['id'] == $p->id ) {
          if ((float) str_replace(",", ".", $i['valor']) != (float) $p->valor_venda) {
            $teve_alteracao++;
          }
        }
      }
    } 

    if ($teve_alteracao && (md5($venda['senha_alterar_preco']) != $config->senha_alterar_preco)) {
      return response()->json(['message' => 'A senha para alterar o valor dos itens está incorreta'], 401);
    }
  }

  $totalVenda = str_replace(",", ".", $venda['valor_total']) + str_replace(",", ".", $venda['acrescimo']) - str_replace(",", ".", $venda['desconto']);

  if($venda['id'] == 0){
    $result = VendaCaixaPreVenda::create([
      'cliente_id' => $venda['cliente'],
      'usuario_id' => $venda['vendedor_id'],
      'natureza_id' => $config->nat_op_padrao,
      'valor_total' => $totalVenda,
      'acrescimo' => str_replace(",", ".", $venda['acrescimo']),
      'troco' => 0,
      'dinheiro_recebido' => 0,
      'forma_pagamento' => " ",
      'tipo_pagamento' => '01',
      'estado' => 'DISPONIVEL',
      'NFcNumero' => 0,
      'chave' => '',
      'path_xml' => '',
      'nome' => '',
      'rascunho' => 0,
      'prevenda_nivel' => $venda['prevenda_nivel'],
      'cpf' => $venda['cpf'] ?? '',
      'observacao' => $venda['observacao'] ?? '',
      'desconto' => $venda['desconto'],
      'pedido_delivery_id' => 0,
      'tipo_pagamento_1' => '', 
      'valor_pagamento_1' => 0,
      'tipo_pagamento_2' => '',
      'valor_pagamento_2' => 0,
      'tipo_pagamento_3' => '',
      'valor_pagamento_3' => 0,
      'empresa_id' => $this->empresa_id,
      'bandeira_cartao' => '99',
      'cAut_cartao' => '',
      'cnpj_cartao' => '',
      'descricao_pag_outros' => '',
    ]);
  }else{
    $result = VendaCaixaPreVenda::find($venda['id']);

    $result->cliente_id = $venda['cliente'];
    $result->natureza_id = $config->nat_op_padrao;
    $result->valor_total = $totalVenda;
    $result->acrescimo = str_replace(",", ".", $venda['acrescimo']);
    $result->troco = str_replace(",", ".", $venda['troco']);
    $result->estado = 'DISPONIVEL';
    $result->prevenda_nivel = $venda['prevenda_nivel'];
    $result->observacao = $venda['observacao'] ?? '';
    $result->desconto = $venda['desconto'];
    $result->update();

    ItemVendaCaixaPreVenda::where('venda_caixa_prevenda_id', $venda['id'])->delete();
      // ComissaoVenda::where('venda_id', $venda['id'])->where('tabela', 'venda_caixas')->delete();
  }

  $itens = $venda['itens'];
  $natureza = NaturezaOperacao::find($config->nat_op_padrao);

  if($venda['prevenda_nivel'] == 2){
      // desconta do estoque se estivere enviando para o caixa
    $this->adicionaItensPrevenda($itens, $result, $config);
    $this->removeDoEstoque($itens, $config);
  }else{
    $this->adicionaItensPrevenda($itens, $result, $config);
  } 

  echo json_encode($result);
}

private function removeDoEstoque($itens, $config){
  $stockMove = new StockMove();

  foreach ($itens as $i) {
    if($config->natureza->nao_movimenta_estoque == false){
      if(!isset($venda['delivery_id']) || $venda['delivery_id'] == 0){
          // nao delivery
        $prod = Produto
        ::where('id', $i['id'])
        ->first();

        if(!empty($prod->receita)){

          $receita = $prod->receita; 

          foreach($receita->itens as $rec){
            if(!empty($rec->produto->receita)){ 

              $receita2 = $rec->produto->receita; 

              foreach($receita2->itens as $rec2){
                $stockMove->downStock(
                  $rec2->produto_id, 
                  (float) str_replace(",", ".", $i['quantidade']) * 
                  ($rec2->quantidade/$receita2->rendimento)
                );
              }
            }else{

              $stockMove->downStock(
                $rec->produto_id, 
                (float) str_replace(",", ".", $i['quantidade']) * 
                ($rec->quantidade/$receita->rendimento)
              );
            }
          }

        }else{
          $stockMove->downStock(
            (int) $i['id'], 
            (float) str_replace(",", ".", $i['quantidade'])
          );
        }
      }
    }

  }
}

private function recalcularCredito($valor_utilizado, $cliente_id){
  $creditos = TrocaVenda::
  where('empresa_id', $this->empresa_id)
  ->where('cliente_id', $cliente_id)
  ->where('status', 0)
  ->orderBy('id', 'desc')
  ->get();

  $tempSoma = 0;
  foreach($creditos as $c){
    $tempSoma += $c->valor_credito;
    $c->status = 1;
    $c->save();
  }

  if($tempSoma > $valor_utilizado){
    $dif = $tempSoma - $valor_utilizado;
    $cr = $creditos[sizeof($creditos)-1];

    $cr->status = 0;
    $cr->valor_credito = $dif;
    $cr->save();
  }
}

private function calcularComissaoVenda($venda, $percentual_comissao){
  $valorRetorno = 0;
  foreach($venda->itens as $i){
    if($i->produto->perc_comissao > 0){
      $valorRetorno += (($i->valor*$i->quantidade) * $i->produto->perc_comissao) / 100;
    }else{
      $valorRetorno += (($i->valor*$i->quantidade) * $percentual_comissao) / 100;
    }
  }
  return $valorRetorno;
}

private function categoriaCrediario(){
  $cat = CategoriaConta::
  where('empresa_id', $this->empresa_id)
  ->where('nome', 'Crediário')
  ->first();
  if($cat != null) return $cat->id;
  $cat = CategoriaConta::create([
    'nome' => 'Crediário',
    'empresa_id' => $this->empresa_id,
    'tipo'=> 'receber'
  ]);
  return $cat->id;
}

private function salvaCredito($vendaId, $totalVenda, $clienteId, $obs, 
  $vencimento){

  $vencimento = str_replace("/", "-", $vencimento);
  $dataVenc = \Carbon\Carbon::parse($vencimento)->format('Y-m-d');

  $categoria = $this->categoriaCrediario();

  $resultConta = ContaReceber::create([
    'venda_caixa_id' => $vendaId,
    'venda_id' => NULL,
    'data_vencimento' => $dataVenc,
    'data_recebimento' => $dataVenc,
    'valor_integral' => $totalVenda,
    'valor_recebido' => 0,
    'status' => false,
    'referencia' => $obs . " - venda PDV " . $vendaId,
    'categoria_id' => $categoria,
    'empresa_id' => $this->empresa_id,
    'cliente_id' => $clienteId
  ]);
}

private function calculaComissao($agendamento){
  $soma = 0;
  $somaDesconto = 0;
  $total = $agendamento->total + $agendamento->desconto;
  foreach($agendamento->itens as $key => $i){
    $tempDesc = 0;
    $valorServico = $i->servico->valor;

    if($key < sizeof($agendamento->itens)-1){

      $media = (((($valorServico - $total)/$total))*100);

      $media = 100 - ($media * -1);
      $tempDesc = ($agendamento->desconto*$media)/100;

      $somaDesconto += $tempDesc;

    }else{
      $tempDesc = $agendamento->desconto - $somaDesconto;
    }

    $comissao = $i->servico->comissao;

    $valorComissao = ($valorServico - $tempDesc) * ($comissao/100);
    $soma += $valorComissao;
  }

  return number_format($soma,2);
}

public function diaria(){
  $ab = AberturaCaixa::where('ultima_venda_nfe', 0)
  ->where('ultima_venda_nfce', 0)
  ->where('empresa_id', $this->empresa_id)
  ->orderBy('id', 'desc')->first();

  date_default_timezone_set('America/Sao_Paulo');
  $hoje = date("Y-m-d") . " 00:00:00";
  $amanha = date('Y-m-d', strtotime('+1 days')). " 00:00:00";
  $vendas = VendaCaixa::
  whereBetween('created_at', [$ab->created_at, 
   $amanha])
  ->where('empresa_id', $this->empresa_id)
  ->get();
  echo json_encode($vendas);
}

public function calcComissao(){

  ComissaoVenda::
  where('empresa_id', $this->empresa_id)
  ->delete();

  $comissao = ComissaoVenda::
  where('empresa_id', $this->empresa_id)
  ->get();

    // echo $comissao;
    // die;

  $vendas = VendaCaixa::
  where('empresa_id', $this->empresa_id)
  ->get();

    // echo $vendas;
    // die;

  foreach($vendas as $v){
    $comissao = ComissaoVenda::
    where('empresa_id', $this->empresa_id)
    ->where('tabela', 'venda_caixas')
    ->where('venda_id', $v->id)
    ->first();
    if($comissao == null){
      try{
        $usuario = Usuario::find($v->usuario_id);
        if(isset($usuario->funcionario)){

          $percentual_comissao = __replace($usuario->funcionario->percentual_comissao);
          $valorComissao = ($v->valor_total * $percentual_comissao) / 100;
          ComissaoVenda::create(
            [
              'funcionario_id' => $usuario->funcionario->id,
              'venda_id' => $v->id,
              'tabela' => 'venda_caixas',
              'valor' => $valorComissao,
              'status' => 0,
              'empresa_id' => $this->empresa_id,
              'created_at' => $v->created_at,
            ]
          );
        }else{
          echo $v->usuario->nome . ' - '. $v->created_at . "<br>";
        }
      }catch(\Exception $e){
        echo "Erro: ". $e->getMessage();
      }
    }

  }
}

public function gerarQrCode(Request $request){
  $config = ConfigNota::
  where('empresa_id', $this->empresa_id)
  ->first();
  $total = (float)number_format($request->valor, 2);
  $result = $this->gerarPix($config, $total);
  if(!isset($result['erro'])){
    return response()->json($result, $result['status']);
  }else{
    return response()->json($result['erro'], $result['status']);
  }
}

private function gerarPix($config, $valor){

  $value = session('user_logged');
  $configCaixa = ConfigCaixa::
  where('usuario_id', get_id_user())
  ->first();

  if($configCaixa == null || $configCaixa->mercadopago_access_token == ""){
    return [
      "erro" => "Configuração de caixa não cadastrada credencias de PIX",
      "status" => 401
    ];
  }

  $cnpj = str_replace(" ", "", $config->cnpj);
  $nome = explode(" ", $config->razao_social);

  try{
    \MercadoPago\SDK::setAccessToken($configCaixa->mercadopago_access_token);

    $payment = new \MercadoPago\Payment();

    $payment->transaction_amount = (float)$valor;
    $payment->description = "Venda PDV";
    $payment->payment_method_id = "pix";

    $cep = str_replace("-", "", $config->cep);
    $payment->payer = array(
      "email" => $config->email,
      "first_name" => $nome[0],
      "last_name" => $nome[1],
      "identification" => array(
        "type" => strlen($cnpj) == 14 ? 'CNPJ' : 'CPF',
        "number" => $cnpj
      ),
      "address"=>  array(
        "zip_code" => str_replace("-", "", $config->cep),
        "street_name" => $config->logradouro,
        "street_number" => $config->numero,
        "neighborhood" => $config->bairro,
        "city" => $config->municipio,
        "federal_unit" => $config->UF
      )
    );

    $payment->save();

    if($payment->transaction_details){
      $qrCode = $payment->point_of_interaction->transaction_data->qr_code_base64;

      return [
        "qrcode" => $qrCode,
        "payment_id" => $payment->id,
        "status" => 200
      ];
    }else{
      return [
        "erro" => $payment->error,
        "status" => 404
      ];
    }
  }catch(\Exception $e){
    return [
      "erro" => $e->getMessage(),
      "status" => 404
    ];
  }
}

public function consultaPix($id){

  $configCaixa = ConfigCaixa::
  where('usuario_id', get_id_user())
  ->first();
  \MercadoPago\SDK::setAccessToken($configCaixa->mercadopago_access_token);
  
  $payStatus = \MercadoPago\Payment::find_by_id($id);
  return response()->json($payStatus->status, 200);
    // return response()->json("approved", 200);
}

private function adicionaAoEstoque($itens, $config){
  $stockMove = new StockMove();

  foreach ($itens as $i) {
    if($config->natureza->nao_movimenta_estoque == false){

      $stockMove->pluStock(
        (int) $i->produto_id, 
        (float) str_replace(",", ".", $i->quantidade)
      );
    }

  }    
}

public function saveTroca(Request $request){

  $venda = $request->venda;    
  $config = ConfigNota::
  where('empresa_id', $this->empresa_id)
  ->first();

    // Verifica se precisa de senha para alterar preço dos itens
  if($config->senha_alterar_preco != ''){
      // verifica se o valor de algum item foi alterado

    $itens = $venda['itens'];
    $ids = [];
    foreach($itens as $i){
      array_push($ids, $i['id']);
    }

    $produtos = Produto::whereIn('id', $ids)->get(['id', 'valor_venda', 'nome']);

    $teve_alteracao = 0;
    foreach($itens as $i){

      foreach ($produtos as $p) {
        if ($i['id'] == $p->id ) {
          if ((float) str_replace(",", ".", $i['valor']) != (float) $p->valor_venda) {
            $teve_alteracao++;
            $somaItens = (float) __replace($i['valor']) * (float) __replace($i['quantidade']) ;

          }
        }
      }
    } 

    if ($teve_alteracao && (md5($venda['senha_alterar_preco']) != $config->senha_alterar_preco)) {
      return response()->json(['message' => 'A senha para alterar o valor dos itens está incorreta'], 401);
    }
  }

  $somaItens = 0;
  $itens = $venda['itens'];
  $ids = [];
  foreach($itens as $i){
    array_push($ids, $i['id']);
  }
  $produtos = Produto::whereIn('id', $ids)->get(['id', 'valor_venda', 'nome']);

  foreach($itens as $i){
    foreach ($produtos as $p) {
      if ($i['id'] == $p->id ) {

        $somaItens = (float) __replace($i['valor']) * (float) __replace($i['quantidade']) ;

      }
    }
  } 


  $totalVenda = str_replace(",", ".", $venda['valor_total']) + str_replace(",", ".", $venda['acrescimo']) - str_replace(",", ".", $venda['desconto']);
  $prod_adicionados = $venda['produtosAdicionados'];
  $prod_removidos = $venda['produtosRemovidos'];


    /**
     * se não tiver ligação com NFCe -> altera a venda ao invez de criar outra
     */

    $vendaAlvo = VendaCaixa::find($venda['venda_alvo']);
    $nfce = $vendaAlvo->NFcNumero;
    $totalAdd = 0;
    $desconto = 0;
    if($nfce == 0 && $totalVenda == 0){
      $result = VendaCaixa::find($venda['id']);

      // $result->valor_total += $totalVenda;
      $result->valor_total = $somaItens;

      $result->troco += str_replace(",", ".", $venda['troco']);
      $result->dinheiro_recebido += str_replace(",", ".", $venda['dinheiro_recebido']);
      
      $result->update();
    }else{
      // $arr = [
      //   '$venda' => $venda,
      // ];

      // return response()->json($arr, 401);
      // exit();


      foreach($prod_adicionados as $p){
        $totalAdd += ((float) str_replace(",", ".", $p['valor']) * (float) str_replace(",", ".", $p['quantidade']));
      }
      $totalRm = 0;
      foreach($prod_removidos as $p){
        $totalRm += ((float) str_replace(",", ".", $p['valor']) * (float) str_replace(",", ".", $p['quantidade']));
      }
      
      $desconto = $totalRm > $totalAdd ? $totalAdd : $totalRm;

      $result = VendaCaixa::create([
        'cliente_id' => $vendaAlvo->cliente,
        'usuario_id' => $vendaAlvo->usuario_id,
        'natureza_id' => $config->nat_op_padrao,
        'valor_total' => ($totalAdd - $desconto),
        'acrescimo' => 0,
        'troco' => str_replace(",", ".", $venda['troco']),
        'dinheiro_recebido' => str_replace(",", ".", $venda['dinheiro_recebido']),
        'forma_pagamento' => $venda['acao'] == 'credito' ? 'credito' : " ",
        'tipo_pagamento' => $venda['tipo_pagamento'],
        'estado' => 'DISPONIVEL',
        'NFcNumero' => 0,
        'chave' => '',
        'path_xml' => '',
        'nome' => $venda['nome'] ?? '',
        'rascunho' => $venda['rascunho'],
        'cpf' => $vendaAlvo->cpf ?? '',
        'observacao' => $venda['observacao'] ?? 'Troca de produto',
        'desconto' => $desconto,
        'pedido_delivery_id' => 0,
        'tipo_pagamento_1' => $venda['tipo_pagamento_1'] ?? '', 
        'valor_pagamento_1' => $venda['valor_pagamento_1'] ? __replace($venda['valor_pagamento_1']) :  0,
        'tipo_pagamento_2' => $venda['tipo_pagamento_2'] ?? '',
        'valor_pagamento_2' => $venda['valor_pagamento_2'] ? __replace($venda['valor_pagamento_2']) : 0,
        'tipo_pagamento_3' => $venda['tipo_pagamento_3'] ?? '',
        'valor_pagamento_3' => $venda['valor_pagamento_3'] ? __replace($venda['valor_pagamento_3']) : 0,
        'empresa_id' => $this->empresa_id,
        'bandeira_cartao' => $venda['bandeira_cartao'],
        'cAut_cartao' => $venda['cAut_cartao'] ?? '',
        'cnpj_cartao' => $venda['cnpj_cartao'] ?? '',
        'descricao_pag_outros' => $venda['descricao_pag_outros'] ?? '',
      ]);
    }

    /**
     * se a venda tiver ultrapassado o desconto e a venda alvo tiver sido feita com multi-pagamento
     * a diferença será adicionada ao multi-pagamento de acordo com o tipo de pagamento selcionado
     */

    // FaturaFrenteCaixa::where('venda_caixa_id', $venda['id'])->delete();
    $pag_multi = FaturaFrenteCaixa::
    where('venda_caixa_id', $vendaAlvo->id)
    ->get();

    if($totalVenda > 0 && sizeof($pag_multi) > 0){
      FaturaFrenteCaixa::create([
        'valor' => __replace($totalVenda),
        'forma_pagamento' => $venda['tipo_pagamento'],
        'venda_caixa_id' => $result->id    
      ]);

      $this->salvaCredito($result->id, __replace($totalVenda), 
        $vendaAlvo->cliente, 'Pagamento tipo "'.$venda['tipo_pagamento'].'"', \Carbon\Carbon::now(), true);
    }

    if($venda['codigo_comanda'] > 0){
      session()->flash('mensagem_erro', 'Pedido não suporta troca');
      return redirect('/frenteCaixa/list');
    }
    if(isset($venda['delivery_id'])){
      session()->flash('mensagem_erro', 'Pedido/Delivery não suporta troca');
      return redirect('/frenteCaixa/list');
    }

    /**
     * Pegar os produtos removidos e retornar ao estoque,
     * deletar o item_venda do banco
     * item_venda_caixas -> delete where venda_caixa_id = venda_alvo['id'] and produto_id = produto_removido['id'] and quantidade = produto_removido['quantidade']
     */
    $stockMove = new StockMove();
    foreach($prod_removidos as $p){
      if($config->natureza->nao_movimenta_estoque == false){
        $prod = Produto::where('id', $p['id'])
        ->first();

        $stockMove->pluStock(
          (int) $p['id'], 
          (float) str_replace(",", ".", $p['quantidade'])
        );
      }

      ItemVendaCaixa::where('venda_caixa_id', $vendaAlvo->id)
      ->where('produto_id', (int) $p['id'])
      ->where('quantidade',(float) str_replace(",", ".", $p['quantidade']))
      ->where('valor', (float) str_replace(",", ".", $p['valor']))
      ->first()
      ->delete();
    }

    /**
     * Pegar os produtos adicionados e descontar do estoque
     * criar o item_venda no banco
     */
    $natureza = NaturezaOperacao::find($config->nat_op_padrao);
    foreach($prod_adicionados as $p){
      $produto = Produto::find($p['id']);
      $cfop = 0;

      if($natureza->sobrescreve_cfop){
        $cfop = $natureza->CFOP_saida_estadual;
      }else{
        $cfop = $produto->CFOP_saida_estadual;
      }

      $prod = Produto::where('id', $p['id'])
      ->first();

      ItemVendaCaixa::create([
        'venda_caixa_id' => $result->id ,
        'produto_id' => (int) $p['id'],
        'quantidade' => (float) str_replace(",", ".", $p['quantidade']),
        'valor' => (float) str_replace(",", ".", $p['valor']),
        'item_pedido_id' => NULL,
        'observacao' => $p['obs'] ?? '',
        'cfop' => $cfop
      ]);

      if($config->natureza->nao_movimenta_estoque == false){
        $stockMove->downStock(
          (int) $p['id'], 
          (float) str_replace(",", ".", $p['quantidade'])
        );
      }
    }

    /**
     * Registra a troca
     */
    $pr = '';
    foreach($prod_removidos as $p){
      $pr .= ' - '.$p['nome'];
    }
    $pa = '';
    foreach($prod_adicionados as $p){
      $pa .= ' - '.$p['nome'];
    }

    TrocaVendaCaixa::create([
      'empresa_id' => $this->empresa_id,
      'antiga_venda_caixas_id' => $vendaAlvo->id,
      'nova_venda_caixas_id' => $result->id,
      'prod_removidos' => $pr,
      'prod_adicionados' => $pa,
      'observacao' => '',
    ]);

    if(($totalAdd - $desconto) > 0){     
      $usuario = Usuario::find($result->usuario_id);

      if(isset($usuario->funcionario)){
        $percentual_comissao = $usuario->funcionario->percentual_comissao;
        $valorComissao = (($totalAdd - $desconto) * $percentual_comissao) / 100;
        ComissaoVenda::create(
          [
            'funcionario_id' => $usuario->funcionario->id,
            'venda_id' => $result->id,
            'tabela' => 'venda_caixas',
            'valor' => $valorComissao,
            'status' => 0,
            'empresa_id' => $this->empresa_id
          ]
        );
      }
    }

    echo json_encode($result);
  }

  private function adicionaItensPrevenda($itens, $result, $config){
    $natureza = NaturezaOperacao::find($config->nat_op_padrao);
    foreach ($itens as $i) {

      $produto = Produto::find($i['id']);
      $cfop = 0;

      if($natureza->sobrescreve_cfop){
        $cfop = $natureza->CFOP_saida_estadual;
      }else{
        $cfop = $produto->CFOP_saida_estadual;
      }

      ItemVendaCaixaPreVenda::create([
        'venda_caixa_prevenda_id' => $result->id,
        'produto_id' => (int) $i['id'],
        'quantidade' => (float) str_replace(",", ".", $i['quantidade']),
        'valor' => (float) str_replace(",", ".", $i['valor']),
        'item_pedido_id' => isset($i['itemPedido']) ? $i['itemPedido'] : NULL,
        'observacao' => $i['obs'] ?? '',
        'cfop' => $cfop
      ]);
    }
  }
}
