<?php

namespace App\Http\Controllers\MP;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DeliveryConfig;
use App\Models\CategoriaProdutoDelivery;
use App\Models\ComplementoDelivery;

class ProdutoController extends Controller
{
    public function categorias($id){
        $delivery = DeliveryConfig::find($id);

        $categorias = CategoriaProdutoDelivery::
        where('empresa_id', $delivery->empresa_id)
        ->with('produtos')
        ->get();

        return response()->json($categorias, 200);
    }

    public function adicionaisDeProduto($id){
        $delivery = DeliveryConfig::find($id);

        $data = ComplementoDelivery::
        where('empresa_id', $delivery->empresa_id)
        ->get();

        return response()->json($data, 200);
    }
}
